/*****************************************************************************
*  LPC8xx SCT demo program
*
*  Use the match reload registers to change the duty cycle of two PWM
*  signals and maintain their dead-time intervals using the NORELOAD_L bit
*  in the SCT Configuration register
*****************************************************************************/
#include "LPC8xx.h"

extern void SCT_Init(void);

#define hperiod    (180)

void SysTick_Handler(void)
{
    LPC_SCT->CONFIG |= (1 << 7);                       // stop reload process for L counter

    if (LPC_GPIO_PORT->PIN0 & (1 << 6))                // P0_6 high?
    {
        if (LPC_SCT->MATCHREL[2].L < hperiod-1)        // check if DC2 < Period of PWM
        {
            LPC_SCT->MATCHREL[1].L ++;
            LPC_SCT->MATCHREL[2].L ++;
        }
    }
    else if (LPC_SCT->MATCHREL[1].L > 1)               // check if DC1 > 1
    {
        LPC_SCT->MATCHREL[1].L --;
        LPC_SCT->MATCHREL[2].L --;
    }
    LPC_SCT->CONFIG &= ~(1 << 7);                      // enable reload process for L counter
}

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 7)              // enable clock to SWM
                               | (1 << 8);             // enable the SCT clock

    LPC_SWM->PINASSIGN6 = 0x07FFFFFF;                  // SCT_OUT0 at P0_7
    LPC_SWM->PINASSIGN7 = 0xFFFFFF08;                  // SCT_OUT1 at P0_8

    SysTick_Config(SystemCoreClock/50);                // SysTick interrupt @ 50 Hz = 20 msec
    SCT_Init();                                        // Initialize SCT0

    while (1)                                          // loop forever
    {
    }
}
